<?php
/*--------------------------------------------------------------
   FetchSpecificProductOptionAction.php 2021-06-29
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Api\Modules\ProductOption\App\Actions;

use Gambio\Admin\Modules\ProductOption\Model\Exceptions\ProductOptionDoesNotExistException;
use Gambio\Admin\Modules\ProductOption\Services\ProductOptionReadService as ProductOptionReadServiceInterface;
use Gambio\Api\Application\Responses\CreateApiMetaDataTrait;
use Gambio\Core\Application\Http\Request;
use Gambio\Core\Application\Http\Response;

/**
 * Class FetchSpecificProductOptionAction
 * @package Gambio\Api\Modules\ProductOption\App\Actions
 */
class FetchSpecificProductOptionAction
{
    use CreateApiMetaDataTrait;
    
    /**
     * @var ProductOptionReadServiceInterface
     */
    private $service;
    
    
    /**
     * FetchSpecificProductOptionAction constructor.
     *
     * @param ProductOptionReadServiceInterface $service
     */
    public function __construct(
        ProductOptionReadServiceInterface $service
    ) {
        $this->service = $service;
    }
    
    /**
     * @param Request  $request
     * @param Response $response
     * @param array    $args
     *
     * @return Response
     */
    public function __invoke(Request $request, Response $response, array $args): Response
    {
        try {
    
            $productId       = (int)$request->getAttribute('productId');
            $productOptionId = (int)$request->getAttribute('optionId');
            $productOption   = $this->service->getProductOptionById($productOptionId);
            
            if ($productId !== $productOption->productId()) {
                
                $errorMessage = 'Product option id "%s" belongs to product id "%s" and not "%s"';
                $errorMessage = sprintf($errorMessage, $productOptionId, $productOption->productId(), $productId);
                
                return $response->withStatus(404)->withJson(['errors' => [[$errorMessage]]]);
            }
            
            $metaData = $this->createApiMetaData();
            
            return $response->withJson([
                                           'data'  => $productOption->toArray(),
                                           '_meta' => $metaData,
                                       ]);
            
        } catch (ProductOptionDoesNotExistException $exception) {
    
            return $response->withStatus(404);
        }
    }
}